<?php 

class DMODS_Hide {
    protected static $registry;
    protected static $db;
    
    protected static $options     = array();
    protected static $dbitems     = array();
    
    protected static $id_index    = 0;
    
    public static $dohtml       = true;
    
    public static $context      = '';
    
    
    public static function init($registry) {
        self::$registry = $registry;
        self::$db       = $registry->db;
    }
    
    public static function is_pro() {
         if (file_exists(DIR . '/dmods/hide_pro/classes/core_pro.php')) {
            if (!class_exists('DMODS_Hide_Pro')) {
                require_once(DIR . '/dmods/hide_pro/classes/core_pro.php');
            }
            
            return true;
        } else {
            return false;
        }
    }
    
    public static function check_permission($permission="") {
        if (empty($permission)) {
            return false;
        }
        
        $bool = self::$registry->userinfo['permissions']['dmods_hide_permissions'] & self::$registry->bf_ugp_dmods_hide_permissions[$permission] ? true : false;
        
        return $bool;
    }
    
    public static function convert_content($content, $function) {
        switch ($function) {
            case 'hide_post_content':
                $replacement = "#\{dmods:\_hide ([0-9]+)?\}#siU";
            break;
            
            case 'unhide_post_content':
                $replacement = "#\{dmods:\_hide ([0-9]+)?\}#siU";
            break;
            
            case 'hide_post_count_content':
                $replacement = '#\{dmods:\_posts ([0-9]+)?\}#siU';
            break;
            
            case 'unhide_post_count_content':
                $replacement = '#\{dmods:\_posts ([0-9]+)?\}#siU';                
            break;
            
            case 'unhide_stg_content':
                $replacement = '#\{dmods:\_stgs ([0-9]+)?\}#siU';
            break;
            
            case 'unhide_thanks_content':
                $replacement = '#\{dmods:\_thanks ([0-9]+)?\}#siU';
            break;
        }
        
        $content = preg_replace_callback($replacement, array(self, $function), $content);
        
        return $content;
    }
    
    public static function strip_hide_identifier($content) {
        $replacements = array(
            '#\{dmods:_hide ([0-9]+)?\}#siU'            
        );
        
        if (self::is_pro()) {
            $replacements = DMODS_Hide_Pro::strip_hide_identifier_pro($replacements);
        }
        
        foreach ($replacements AS $replacement) {
            $content = preg_replace($replacement, '', $content);
        }
        
        return $content;
    }
    
    public static function remove_old_content($identifier=0) {
        $identifier = intval($identifier);
        
        self::$db->query_write("
            DELETE FROM " . TABLE_PREFIX . "dmods_hide_content
            WHERE identifier = $identifier
        ");
        
        return true;
    }
    
    protected static function hide_post_count_content($regex, $posts=10) {        
        if (self::is_pro()) {
            return DMODS_Hide_Pro::hide_post_count_content_pro($regex, $posts);
        }
    }
    
    protected static function unhide_post_count_content($regex) {
        if (self::is_pro()) {
            return DMODS_Hide_Pro::unhide_post_count_content_pro($regex);
        }
    }
    
    protected static function hide_stg_content($regex) {
        if (self::is_pro()) {
            return DMODS_Hide_Pro::hide_stg_content_pro($regex);
        }
    }
    
    protected static function hide_thanks_content($regex) {
        if (self::is_pro()) {
            return DMODS_Hide_Pro::hide_thanks_content_pro($regex);
        }
    }
    
    protected static function unhide_stg_content($regex) {
        if (self::is_pro()) {
            return DMODS_Hide_Pro::unhide_stg_content_pro($regex);
        }
    }
    
    protected static function unhide_thanks_content($regex) {
        if (self::is_pro()) {
            return DMODS_Hide_Pro::unhide_thanks_content_pro($regex);
        }
     }
    
    protected static function hide_post_content($regex) {
        global $vbphrase;
        
        if (self::$dohtml == true) {
            return $vbphrase['dmods_hide_hidden_content'];
        } else {
            return $vbphrase['dmods_hide_hidden_content_nohtml'];
        }
    }
    
    protected static function unhide_post_content($regex) {
        global $post, $thread;
        
        if (self::$context == 'preview') {
            $userid = $thread['userid'];
            $threadid = $thread['threadid'];
        } else {
            $userid = $post['userid'];
            $threadid = $post['threadid'];
        }
        
        $contentid = intval($regex[1]);
        $content = self::fetch_content($contentid);
        
        if ($content == false) {
            return self::hide_post_content($regex);
        }
        
        if (self::$registry->options['dmods_hide_hide_tag'] == false) {
            return $content['content'];
        }
        
        if (empty($post) && self::$context != 'preview') {
            return self::hide_post_content($regex);
        }
        
        if (empty($thread) && self::$context == 'preview') {
            return self::hide_post_content($regex);
        }
        
        // Check if posted in this thread
        $posted = self::check_posted($threadid);
        
        // Convert DMODS Hide syntax
        if ($posted == false && $userid != $vbulletin->userinfo['userid']) {
            return self::hide_post_content($regex);
        }
        
        if (self::$context == 'preview') {
            $content['content'] = strip_tags(str_replace(array('[', ']'), array('<', '>'), $content['content']), "");
        }
        
        return $content['content'];
    }
    
    protected static function fetch_content($contentid=0) {
        $content = self::$registry->db->query_first("
            SELECT * FROM " . TABLE_PREFIX . "dmods_hide_content
            WHERE contentid = $contentid
        ");
        
        if (!empty($content)) {
            return $content;
        } else {
            return false;
        }
    }
    
    public static function check_posted($threadid=0) {
        $post = self::$registry->db->query_first("
            SELECT postid FROM " . TABLE_PREFIX . "post
            WHERE   userid      = " . self::$registry->userinfo['userid'] . "
                AND threadid    = " . intval($threadid) . " 
        ");
        
        if (!$post['postid']) {
            return false;
        } else {
            return true;
        }
    }
    
    public static function hide_content($content) {
        $tags = array(
            'tag_hide'      => '#\[HIDE\](.+)\[\/HIDE\]#siU',
            'tag_reply'      => '#\[HIDE-REPLY\](.+)\[\/HIDE-REPLY\]#siU',
        );
        
        if (self::is_pro()) {
            $tags = DMODS_Hide_Pro::hide_content_pro($tags);
        }
        
        foreach ($tags AS $function => $replacement) {
            $content = preg_replace_callback($replacement, array(self, $function), $content);                    
        }
        
        return $content;
    }
    
    public static function unhide_content($content) {
        $tags = array(
            'tag_hide_unhide'      => '#\{dmods:_hide ([0-9]*)\}#siU'
        );
        
        if (self::is_pro()) {
            $tags = DMODS_Hide_Pro::unhide_content_pro($tags);
        }
        
        foreach ($tags AS $function => $replacement) {
            $content = preg_replace_callback($replacement, array(self, $function), $content);
        }
        
        return $content;
    }
    
    protected static function tag_hide_unhide($regex) {
        if (intval($regex[1]) == 0) {
            return $regex[0];
        }
        
        $content = self::fetch_content($regex[1]);
        
        if ($content == false) {
            return $regex[0];
        }
        
        return "[HIDE]" . $content['content'] . "[/HIDE]";
    }
    
    protected static function tag_posts_unhide($regex) {
        if (self::is_pro()) {
            return DMODS_Hide_Pro::tag_posts_unhide_pro($regex);
        }
    }
    
    protected static function tag_stg_unhide($regex) {
        if (self::is_pro()) {
            return DMODS_Hide_Pro::tag_stg_unhide_pro($regex);
        }
    }
    
    protected static function tag_stg($regex) {
        if (self::is_pro()) {
            return DMODS_Hide_Pro::tag_stg_pro($regex);
        }
    }
    
    protected static function tag_posts($regex) {
        if (self::is_pro()) {
            return DMODS_Hide_Pro::tag_posts_pro($regex);
        }
    }
    
    protected static function tag_thanks($regex) {
        if (self::is_pro()) {
            return DMODS_Hide_Pro::tag_thanks_pro($regex);
        }
    }
    
    protected static function tag_thanks_unhide($regex) {
        if (self::is_pro()) {
            return DMODS_Hide_Pro::tag_thanks_unhide_pro($regex);
        }
    }
    
    protected static function tag_hide($regex) {
        if (empty($regex[1])) {
            return $regex[1];
        }
        
        if (self::check_permission('dmods_hide_can_hide') == false) {
            return $regex[1];
        }
        
        if (self::$registry->options['dmods_hide_hide_tag'] == false) {
            return $regex[1];
        }
        
        require_once(DIR . '/includes/class_wysiwygparser.php');
        $html_parser = new vB_WysiwygHtmlParser(self::$registry);
		$regex[1] = $html_parser->parse_wysiwyg_html_to_bbcode($regex[1], false);
        
        self::$dbitems['content'][] = $regex[1];
        self::$dbitems['params'][]  = array();
        self::$dbitems['types'][]   = 'hide';
        
        $lastid = self::$registry->db->query_first("
            SELECT contentid FROM " . TABLE_PREFIX . "dmods_hide_content
            ORDER BY contentid DESC
        ");
        
        $newid = intval($lastid['contentid']) + self::$id_index;
        $newid++;
        self::$id_index++;
        
        return "{dmods:_hide $newid}";
    }
    
    protected function tag_reply($regex) {
        return self::tag_hide($regex);
    }
    
    public function set_option($name, $value) {
        self::$options[$name] = $value;
    }
    
    public function insert_tag_content($context="") {
        switch ($context) {
            case 'thread':
                $identifier = intval(self::$options['thread']);
            break;
        }
        
        if (!$identifier) return;
        if (empty(self::$dbitems['content'])) return;
        if (empty(self::$dbitems['types'])) return;
        
        if (!empty(self::$dbitems['content'])) {
            foreach (self::$dbitems['content'] AS $i => $content) {                
                self::$registry->db->query_write("
                    INSERT INTO " . TABLE_PREFIX . "dmods_hide_content (type, userid, content, identifier, params)
                    VALUES  (
                                '" . self::$registry->db->escape_string(self::$dbitems['types'][$i]) . "',
                                " . self::$registry->userinfo['userid'] . ",
                                '" . self::$registry->db->escape_string($content) . "',
                                " . $identifier . ",
                                '" . self::$registry->db->escape_string(serialize(self::$dbitems['params'][$i])) . "'
                            )                    
                ");                
                switch ($context) {
                    case 'thread':
                        self::$registry->db->query_write("
                            UPDATE " . TABLE_PREFIX . "thread
                                SET
                                    dmods_live_hide = '1'
                            WHERE threadid = $identifier
                        ");
                    break;
                }
            }
        }
    }
}

?>